function [fdSpd, fdTrq, fdPrf] = finalDriveModel(wheelSpd, wheelTrq, fd)
% Final Drive

% Final drive input speed (rad/s)
fdSpd = fd.spdRatio .* wheelSpd;

switch fd.lossMethod
    case 'eff'
        % Gearbox efficiency (-)
        fdEff(:) = fd.eff;

        lossTrq = ( 1 - fdEff ) ./ fdEff ./ fd.spdRatio .* wheelTrq;

    case 'trqLossMap'
        wheelSpd = wheelSpd.*ones(size(wheelTrq));
        lossTrq = fd.trqLossMap(wheelSpd, wheelTrq);
        
end

% Final drive input torque (Nm)
fdTrq  = wheelTrq ./ fd.spdRatio + lossTrq;

%% Pack outputs
fdPrf.fdSpd = fdSpd;
fdPrf.fdTrq = fdTrq;
fdPrf.fdLossTrq = lossTrq;


